﻿namespace Microsoft.Samples.PlanMyNight.Web.Tests
{
    using System;
    using System.Security.Principal;
    using System.Web;
    using System.Web.Security;
    using Microsoft.VisualStudio.TestTools.UnitTesting;
    using Moq;

    [TestClass]
    public class MembershipWrappersFixture
    {
        [TestMethod]
        public void FormsAuthenticationSignInSetsPrincipal()
        {
            var response = new Mock<HttpResponseBase>();
            var cookies = new HttpCookieCollection();
            response.Setup(o => o.Cookies).Returns(cookies);
            IPrincipal principalResult = null;

            var httpContext = new Mock<HttpContextBase>();
            httpContext.Setup(o => o.Response).Returns(response.Object);
            httpContext.SetupSet(o => o.User).Callback((IPrincipal p) => principalResult = p);

            var formsAuthentication = new FormsAuthenticationService(httpContext.Object);
            formsAuthentication.SignIn("test-user-1", false);

            httpContext.VerifyAll();
            Assert.AreEqual(1, cookies.Count);
            Assert.IsNotNull(principalResult);
            Assert.IsInstanceOfType(principalResult, typeof(GenericPrincipal));
            Assert.AreEqual("test-user-1", principalResult.Identity.Name);
        }

        [TestMethod]
        public void FormsAuthenticationSignOutExpiresCookie()
        {
            var response = new Mock<HttpResponseBase>();
            var cookies = new HttpCookieCollection();
            cookies.Add(new HttpCookie(FormsAuthentication.FormsCookieName) { Expires = DateTime.Now.AddDays(2), Value = "......." });
            response.Setup(o => o.Cookies).Returns(cookies);

            var httpContext = new Mock<HttpContextBase>();
            httpContext.Setup(o => o.Response).Returns(response.Object);

            var formsAuthentication = new FormsAuthenticationService(httpContext.Object);
            formsAuthentication.SignOut();

            Assert.IsTrue(cookies[0].Expires < DateTime.Now);
        }
    }
}
